
/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developer bulletin board at forum.melissadata.com.
********************************************************************************/

import com.melissadata.*;
import java.io.*;

public class ParseZipStreetSample {

  public static String the_license = "";
  public static String datafile_dir = "/DQT/Current";
  public static BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
  
  public static void run_mdParse_example() throws IOException
  {
    // US Only

    mdParse ps;

    /* mdParse does not require data files */
    ps = new mdParse();
    System.out.println("Parse Interface:");
    System.out.print("Enter Address Line: ");
    ps.Parse(stdin.readLine());

    System.out.println("Parse Results: ");
    System.out.println("Range: " + ps.GetRange());
    System.out.println("PreDirection: " + ps.GetPreDirection());
    System.out.println("StreetName: " + ps.GetStreetName());
    System.out.println("Suffix: " + ps.GetSuffix());
    System.out.println("PostDirection: " + ps.GetPostDirection());
    System.out.println("SuiteName: " + ps.GetSuiteName());
    System.out.println("SuiteNumber: " + ps.GetSuiteNumber());
    System.out.println("PrivateMailboxName: " + ps.GetPrivateMailboxName());
    System.out.println("PrivateMailboxNumber: " + ps.GetPrivateMailboxNumber());
    System.out.println("Garbage: " + ps.GetGarbage());
    System.out.println("");

    //Call ParseNext for more Parse Results
    
    System.out.print("Enter City/State/Zip LastLine: ");
    ps.LastLineParse(stdin.readLine());
    System.out.println("City: " + ps.GetCity());
    System.out.println("State: " + ps.GetState());
    System.out.println("Zip: " + ps.GetZip());
    System.out.println("");
    ps.delete();
  }

  public static void run_mdStreet_example() throws IOException
  {
    boolean i;
    mdStreet sl = new mdStreet();
    
    System.out.println("Street Data Interface");
    sl.Initialize( datafile_dir,  datafile_dir,  datafile_dir);
    sl.SetLicenseString(the_license);
    System.out.println("Build number: " + sl.GetBuildNumber());
    System.out.println("Database Date: " + sl.GetDatabaseDate());

    System.out.println(
      "Initialization Error (if any): " + sl.GetInitializeErrorString());

    String street = "";
    String zip = "";
    System.out.print("Enter Street Name: ");
    street = stdin.readLine();
    System.out.print("Enter Zip: ");
    zip = stdin.readLine();
    i = sl.FindStreet(street, zip, false);

    while(i == true)
    {
    	String record = sl.GetPrimaryRangeLow()+"-"+sl.GetPrimaryRangeHigh()+" "+sl.GetPrimaryRangeOddEven()+" "+sl.GetPreDirection()+" "+sl.GetStreetName()+" "+sl.GetPostDirection()+" "+sl.GetSuffix();
      if(sl.GetSuiteRangeLow() != "")
	{
		record += " "+sl.GetSuiteRangeLow()+"-"+sl.GetSuiteRangeHigh()+" "+sl.GetSuiteRangeOddEven();
	}
	System.out.println(record);

	i = sl.FindStreetNext();
    }
    sl.delete();
    System.out.println("");
  }

  public static void run_mdZip_example() throws IOException
  {
    boolean i;
    mdZip zip = new mdZip();

    zip.Initialize( datafile_dir, datafile_dir, datafile_dir);

    zip.SetLicenseString(the_license);
    System.out.println("Zip Data Interface");
    System.out.println("Build number: " + zip.GetBuildNumber());
    System.out.println("Database Date: " + zip.GetDatabaseDate());

    System.out.println(
      "Initialization Error (if any): " + zip.GetInitializeErrorString());

    /* call a find zip function */
    System.out.print("Enter Zip: ");

    i = zip.FindZip(stdin.readLine(), false);
    while(i == true)
    {
    	String record = zip.GetZip()+" "+zip.GetCity()+" "+zip.GetCityAbbreviation()+" "+zip.GetState()+" "+zip.GetCountyName()+" "+zip.GetCountyFips()+" "+zip.GetLastLineIndicator()+" "+zip.GetZipType();
     	System.out.println(record);

	i = zip.FindZipNext();
    }
    zip.delete();
    System.out.println("");
  }

  public static void main(String args[]) throws IOException
  {
    
    run_mdParse_example();
    run_mdStreet_example();
    run_mdZip_example();

    System.gc();
    System.runFinalization();
  }

}
